\name{h2o-package}
\alias{h2o-package}
\alias{h2o}
\docType{package}
\title{
H2O R Interface
}
\description{
This is a package for running H2O via its REST API from within R. To communicate with a H2O instance, the version of the R package must match the version of H2O. When connecting to a new H2O cluster, it is necessary to re-run the initializer.
}
\details{
\tabular{ll}{
Package: \tab h2o\cr
Type: \tab Package\cr
Version: \tab 3.13.0.3943\cr
Branch: \tab master\cr
Date: \tab Sat Jul 01 23:34:36 PDT 2017\cr
License: \tab Apache License (== 2.0)\cr
Depends: \tab R (>= 2.13.0), RCurl, jsonlite, statmod, tools, methods, utils\cr
}

This package allows the user to run basic H2O commands using R commands. In order to use it, you must first have H2O running. To run H2O on your local machine, call \code{h2o.init} without any arguments, and H2O will be automatically launched at localhost:54321, where the IP is "127.0.0.1" and the port is 54321. If H2O is running on a cluster, you must provide the IP and port of the remote machine as arguments to the h2o.init() call.

H2O supports a number of standard statistical models, such as GLM, K-means, and Random Forest. For example, to run GLM, call \code{\link{h2o.glm}} with the H2O parsed data and parameters (response variable, error distribution, etc...) as arguments. (The operation will be done on the server associated with the data object where H2O is running, not within the R environment).

Note that no actual data is stored in the R workspace; and no actual work is carried out by R. R only saves the named objects, which uniquely identify the data set, model, etc on the server. When the user makes a request, R queries the server via the REST API, which returns a JSON file with the relevant information that R then displays in the console.

If you are using an older version of H2O, use the following porting guide to update your scripts: \href{https://github.com/h2oai/h2o-dev/blob/master/h2o-docs/src/product/upgrade/H2ODevPortingRScripts.md}{Porting Scripts}
}
\author{
Anqi Fu, Tom Kraljevic and Petr Maj, with contributions from the H2O.ai team

Maintainer: Tom Kraljevic <tomk@0xdata.com>
}
\references{
\itemize{
  \item \href{http://www.h2o.ai}{H2O.ai Homepage}
  \item \href{http://docs.h2o.ai}{H2O Documentation}
  \item \href{https://github.com/h2oai/h2o-3}{H2O on GitHub}
  }
}
\keyword{ package }
