# This file is auto-generated by h2o-3/h2o-bindings/bin/gen_R.py
# Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details) 
#
# -------------------------- HGLM Model -------------------------- #
#'
#' Fits a HGLM model with both the residual noise and random effect being modeled by Gaussian distribution.  The fixed
#' effect coefficients are specified in parameter x, the random effect coefficients are specified in parameter 
#' random_columns.  The column specified in group_column will contain the level 2 index value and must be an enum column.
#' 
#'
#' @param x (Optional) A vector containing the names or indices of the predictor variables to use in building the model.
#'        If x is missing, then all columns except y are used.
#' @param y The name or column index of the response variable in the data. 
#'        The response must be either a numeric or a categorical/factor variable. 
#'        If the response is numeric, then a regression model will be trained, otherwise it will train a classification model.
#' @param training_frame Id of the training data frame.
#' @param random_columns Random columns indices for HGLM.
#' @param group_column Group column is the column that is categorical and used to generate the groups in HGLM
#' @param model_id Destination id for this model; auto-generated if not specified.
#' @param validation_frame Id of the validation data frame.
#' @param ignore_const_cols \code{Logical}. Ignore constant columns. Defaults to TRUE.
#' @param offset_column Offset column. This will be added to the combination of columns before applying the link function.
#' @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to excluding it from
#'        the dataset; giving an observation a relative weight of 2 is equivalent to repeating that row twice. Negative
#'        weights are not allowed. Note: Weights are per-row observation weights and do not increase the size of the
#'        data frame. This is typically the number of times a row is repeated, but non-integer values are supported as
#'        well. During training, rows with higher weights matter more, due to the larger loss function pre-factor. If
#'        you set weight = 0 for a row, the returned prediction frame at that row is zero and this is incorrect. To get
#'        an accurate prediction, remove all rows with weight == 0.
#' @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable. Defaults to 0.
#' @param custom_metric_func Reference to custom evaluation function, format: `language:keyName=funcName`
#' @param score_each_iteration \code{Logical}. Whether to score during each iteration of model training. Defaults to FALSE.
#' @param score_iteration_interval Perform scoring for every score_iteration_interval iterations. Defaults to 5.
#' @param seed Seed for random numbers (affects certain parts of the algo that are stochastic and those might or might not be enabled by default).
#'        Defaults to -1 (time-based random number).
#' @param missing_values_handling Handling of missing values. Either MeanImputation, Skip or PlugValues. Must be one of: "MeanImputation",
#'        "Skip", "PlugValues". Defaults to MeanImputation.
#' @param plug_values Plug Values (a single row frame containing values that will be used to impute missing values of the
#'        training/validation frame, use with conjunction missing_values_handling = PlugValues).
#' @param family Family. Only gaussian is supported now. Must be one of: "gaussian". Defaults to gaussian.
#' @param rand_family Set distribution of random effects.  Only Gaussian is implemented now. Must be one of: "gaussian".
#' @param max_iterations Maximum number of iterations.  Value should >=1.  A value of 0 is only set when only the model coefficient
#'        names and model coefficient dimensions are needed. Defaults to -1.
#' @param initial_fixed_effects An array that contains initial values of the fixed effects coefficient.
#' @param initial_random_effects A H2OFrame id that contains initial values of the random effects coefficient.  The row names shouldbe the
#'        random coefficient names.  If you are not sure what the random coefficient names are, build HGLM model with
#'        max_iterations = 0 and checkout the model output field random_coefficient_names.  The number of rows of this
#'        frame should be the number of level 2 units.  Again, to figure this out, build HGLM model with
#'        max_iterations=0 and check out the model output field group_column_names.  The number of rows should equal the
#'        length of thegroup_column_names.
#' @param initial_t_matrix A H2OFrame id that contains initial values of the T matrix.  It should be a positive symmetric matrix.
#' @param tau_u_var_init Initial variance of random coefficient effects.  If set, should provide a value > 0.0.  If not set, will be
#'        randomly set in the model building process. Defaults to 0.
#' @param tau_e_var_init Initial variance of random noise.  If set, should provide a value > 0.0.  If not set, will be randomly set in
#'        the model building process. Defaults to 0.
#' @param method We only implemented EM as a method to obtain the fixed, random coefficients and the various variances. Must be
#'        one of: "EM". Defaults to EM.
#' @param em_epsilon Converge if beta/ubeta/tmat/tauEVar changes less (using L-infinity norm) than em esilon. ONLY applies to EM
#'        method. Defaults to 0.001.
#' @param random_intercept \code{Logical}. If true, will allow random component to the GLM coefficients. Defaults to TRUE.
#' @param gen_syn_data \code{Logical}. If true, add gaussian noise with variance specified in parms._tau_e_var_init. Defaults to
#'        FALSE.
#' @examples
#' \dontrun{
#' library(h2o)
#' h2o.init()
#' # build a HGLM model with prostate dataset
#' prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
#' prostate <- h2o.uploadFile(path = prostate_path)
#' prostate$RACE <- as.factor(prostate$RACE)
#' model <- h2o.hglm(y="VOL", x=c("AGE","RACE","DPROS"), random_columns = ["AGE"], 
#'                   group_column = "RACE", training_frame=prostate)
#' 
#' }
#' @export
h2o.hglm <- function(x,
                     y,
                     training_frame,
                     random_columns,
                     group_column,
                     model_id = NULL,
                     validation_frame = NULL,
                     ignore_const_cols = TRUE,
                     offset_column = NULL,
                     weights_column = NULL,
                     max_runtime_secs = 0,
                     custom_metric_func = NULL,
                     score_each_iteration = FALSE,
                     score_iteration_interval = 5,
                     seed = -1,
                     missing_values_handling = c("MeanImputation", "Skip", "PlugValues"),
                     plug_values = NULL,
                     family = c("gaussian"),
                     rand_family = c("gaussian"),
                     max_iterations = -1,
                     initial_fixed_effects = NULL,
                     initial_random_effects = NULL,
                     initial_t_matrix = NULL,
                     tau_u_var_init = 0,
                     tau_e_var_init = 0,
                     method = c("EM"),
                     em_epsilon = 0.001,
                     random_intercept = TRUE,
                     gen_syn_data = FALSE)
{
  # Validate required training_frame first and other frame args: should be a valid key or an H2OFrame object
  training_frame <- .validate.H2OFrame(training_frame, required=TRUE)
  validation_frame <- .validate.H2OFrame(validation_frame, required=FALSE)

  # Validate other required args
  # If x is missing, then assume user wants to use all columns as features.
  if (missing(x)) {
     if (is.numeric(y)) {
         x <- setdiff(col(training_frame), y)
     } else {
         x <- setdiff(colnames(training_frame), y)
     }
  }

  # Build parameter list to send to model builder
  parms <- list()
  parms$training_frame <- training_frame
  args <- .verify_dataxy(training_frame, x, y)
  if (!missing(random_columns)) {
      parms$random_columns <- random_columns
  } else {
      stop("random_columns is required.")
  }
  if (!missing(group_column)) {
      parms$group_column <- group_column
  } else {
      stop("group_column is required.")
  }
  parms$ignored_columns <- args$x_ignore
  parms$response_column <- args$y

  if (!missing(model_id))
    parms$model_id <- model_id
  if (!missing(validation_frame))
    parms$validation_frame <- validation_frame
  if (!missing(ignore_const_cols))
    parms$ignore_const_cols <- ignore_const_cols
  if (!missing(offset_column))
    parms$offset_column <- offset_column
  if (!missing(weights_column))
    parms$weights_column <- weights_column
  if (!missing(max_runtime_secs))
    parms$max_runtime_secs <- max_runtime_secs
  if (!missing(custom_metric_func))
    parms$custom_metric_func <- custom_metric_func
  if (!missing(score_each_iteration))
    parms$score_each_iteration <- score_each_iteration
  if (!missing(score_iteration_interval))
    parms$score_iteration_interval <- score_iteration_interval
  if (!missing(seed))
    parms$seed <- seed
  if (!missing(missing_values_handling))
    parms$missing_values_handling <- missing_values_handling
  if (!missing(plug_values))
    parms$plug_values <- plug_values
  if (!missing(family))
    parms$family <- family
  if (!missing(rand_family))
    parms$rand_family <- rand_family
  if (!missing(max_iterations))
    parms$max_iterations <- max_iterations
  if (!missing(initial_fixed_effects))
    parms$initial_fixed_effects <- initial_fixed_effects
  if (!missing(initial_random_effects))
    parms$initial_random_effects <- initial_random_effects
  if (!missing(initial_t_matrix))
    parms$initial_t_matrix <- initial_t_matrix
  if (!missing(tau_u_var_init))
    parms$tau_u_var_init <- tau_u_var_init
  if (!missing(tau_e_var_init))
    parms$tau_e_var_init <- tau_e_var_init
  if (!missing(random_columns))
    parms$random_columns <- random_columns
  if (!missing(method))
    parms$method <- method
  if (!missing(em_epsilon))
    parms$em_epsilon <- em_epsilon
  if (!missing(random_intercept))
    parms$random_intercept <- random_intercept
  if (!missing(group_column))
    parms$group_column <- group_column
  if (!missing(gen_syn_data))
    parms$gen_syn_data <- gen_syn_data

  # Error check and build model
  model <- .h2o.modelJob('hglm', parms, h2oRestApiVersion=3, verbose=FALSE)
  return(model)
}
.h2o.train_segments_hglm <- function(x,
                                     y,
                                     training_frame,
                                     random_columns,
                                     group_column,
                                     validation_frame = NULL,
                                     ignore_const_cols = TRUE,
                                     offset_column = NULL,
                                     weights_column = NULL,
                                     max_runtime_secs = 0,
                                     custom_metric_func = NULL,
                                     score_each_iteration = FALSE,
                                     score_iteration_interval = 5,
                                     seed = -1,
                                     missing_values_handling = c("MeanImputation", "Skip", "PlugValues"),
                                     plug_values = NULL,
                                     family = c("gaussian"),
                                     rand_family = c("gaussian"),
                                     max_iterations = -1,
                                     initial_fixed_effects = NULL,
                                     initial_random_effects = NULL,
                                     initial_t_matrix = NULL,
                                     tau_u_var_init = 0,
                                     tau_e_var_init = 0,
                                     method = c("EM"),
                                     em_epsilon = 0.001,
                                     random_intercept = TRUE,
                                     gen_syn_data = FALSE,
                                     segment_columns = NULL,
                                     segment_models_id = NULL,
                                     parallelism = 1)
{
  # formally define variables that were excluded from function parameters
  model_id <- NULL
  verbose <- NULL
  destination_key <- NULL
  # Validate required training_frame first and other frame args: should be a valid key or an H2OFrame object
  training_frame <- .validate.H2OFrame(training_frame, required=TRUE)
  validation_frame <- .validate.H2OFrame(validation_frame, required=FALSE)

  # Validate other required args
  # If x is missing, then assume user wants to use all columns as features.
  if (missing(x)) {
     if (is.numeric(y)) {
         x <- setdiff(col(training_frame), y)
     } else {
         x <- setdiff(colnames(training_frame), y)
     }
  }

  # Build parameter list to send to model builder
  parms <- list()
  parms$training_frame <- training_frame
  args <- .verify_dataxy(training_frame, x, y)
  if (!missing(random_columns)) {
      parms$random_columns <- random_columns
  } else {
      stop("random_columns is required.")
  }
  if (!missing(group_column)) {
      parms$group_column <- group_column
  } else {
      stop("group_column is required.")
  }
  parms$ignored_columns <- args$x_ignore
  parms$response_column <- args$y

  if (!missing(validation_frame))
    parms$validation_frame <- validation_frame
  if (!missing(ignore_const_cols))
    parms$ignore_const_cols <- ignore_const_cols
  if (!missing(offset_column))
    parms$offset_column <- offset_column
  if (!missing(weights_column))
    parms$weights_column <- weights_column
  if (!missing(max_runtime_secs))
    parms$max_runtime_secs <- max_runtime_secs
  if (!missing(custom_metric_func))
    parms$custom_metric_func <- custom_metric_func
  if (!missing(score_each_iteration))
    parms$score_each_iteration <- score_each_iteration
  if (!missing(score_iteration_interval))
    parms$score_iteration_interval <- score_iteration_interval
  if (!missing(seed))
    parms$seed <- seed
  if (!missing(missing_values_handling))
    parms$missing_values_handling <- missing_values_handling
  if (!missing(plug_values))
    parms$plug_values <- plug_values
  if (!missing(family))
    parms$family <- family
  if (!missing(rand_family))
    parms$rand_family <- rand_family
  if (!missing(max_iterations))
    parms$max_iterations <- max_iterations
  if (!missing(initial_fixed_effects))
    parms$initial_fixed_effects <- initial_fixed_effects
  if (!missing(initial_random_effects))
    parms$initial_random_effects <- initial_random_effects
  if (!missing(initial_t_matrix))
    parms$initial_t_matrix <- initial_t_matrix
  if (!missing(tau_u_var_init))
    parms$tau_u_var_init <- tau_u_var_init
  if (!missing(tau_e_var_init))
    parms$tau_e_var_init <- tau_e_var_init
  if (!missing(random_columns))
    parms$random_columns <- random_columns
  if (!missing(method))
    parms$method <- method
  if (!missing(em_epsilon))
    parms$em_epsilon <- em_epsilon
  if (!missing(random_intercept))
    parms$random_intercept <- random_intercept
  if (!missing(group_column))
    parms$group_column <- group_column
  if (!missing(gen_syn_data))
    parms$gen_syn_data <- gen_syn_data

  # Build segment-models specific parameters
  segment_parms <- list()
  if (!missing(segment_columns))
    segment_parms$segment_columns <- segment_columns
  if (!missing(segment_models_id))
    segment_parms$segment_models_id <- segment_models_id
  segment_parms$parallelism <- parallelism

  # Error check and build segment models
  segment_models <- .h2o.segmentModelsJob('hglm', segment_parms, parms, h2oRestApiVersion=3)
  return(segment_models)
}


#' Extracts the random effects coefficients of an HGLM model.
#'
#' @param model is a H2O HGLM model.
#' @export
h2o.coef_random <- function(model) {
    if (is(model, "H2OModel") && (model@algorithm=="hglm"))
        return(model@model$ubeta)
}

#' Extracts the group_column levels of an HGLM model.  The group_column is usually referred to as level 2 predictor.
#'
#' @param model is a H2O HGLM model.
#' @export
h2o.level_2_names <- function(model) {
    if (is(model, "H2OModel") && (model@algorithm=="hglm"))
        return(model@model$group_column_names)
}

#' Extracts the coefficient names of random effect coefficients.
#'
#' @param model is a H2O HGLM model.
#' @export
h2o.coefs_random_names <- function(model) {
    if (is(model, "H2OModel") && (model@algorithm=="hglm"))
        return(model@model$random_coefficient_names)
}

#' Extracts scoring history of validation dataframe during training
#'
#' @param model is a H2O HGLM model.
#' @export
h2o.scoring_history_valid <- function(model) {
    if (is(model, "H2OModel") && (model@algorithm=="hglm"))
        return(model@model$scoring_history_valid)
}

#' Extracts scoring history of training dataframe during training
#'
#' @param model is a H2O HGLM model.
#' @export
h2o.scoring_history <- function(model) {
    if (is(model, "H2OModel") && (model@algorithm=="hglm"))
        return(model@model$scoring_history)
}

#' Extracts T matrix which is the covariance of random effect coefficients.
#'
#' @param model is a H2O HGLM model.
#' @export
h2o.matrix_T <- function(model) {
    if (is(model, "H2OModel") && (model@algorithm=="hglm"))
        return(model@model$tmat)
}

#' Extracts the variance of residuals of the HGLM model.
#'
#' @param model is a H2O HGLM model.
#' @export
h2o.residual_variance <- function(model) {
    if (is(model, "H2OModel") && (model@algorithm=="hglm"))
        return(model@model$residual_variance)
}

#' Extracts the ICC of the HGLM model.
#'
#' @param model is a H2O HGLM model.
#' @export
h2o.icc <- function(model) {
    if (is(model, "H2OModel") && (model@algorithm=="hglm"))
        return(model@model$icc)
}

#' Extracts the mean residual error taking into account only the fixed effect coefficients.
#'
#' @param model is a H2O HGLM model.
#' @param train is true for training and false for validation dataset
#' @export
h2o.mean_residual_fixed <- function(model, train=TRUE) {
    if (is(model, "H2OModel") && (model@algorithm=="hglm")) {
        if (train)
            return(model@model$mean_residual_fixed)
        else
           return(model@model$mean_residual_fixed_valid) 
    }
}
    
