% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.all_constraints_passed}
\alias{h2o.all_constraints_passed}
\title{Return the TRUE if all constraints are satisfied for a constraint GLM model and FALSE otherwise.  If you want to 
check which constraint failed, use h2o.get_constraints_info method.}
\usage{
h2o.all_constraints_passed(object)
}
\arguments{
\item{object}{An \linkS4class{H2OModel} object.}
}
\description{
Return the TRUE if all constraints are satisfied for a constraint GLM model and FALSE otherwise.  If you want to 
check which constraint failed, use h2o.get_constraints_info method.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv"
cars <- h2o.importFile(f)
predictors <- c("displacement", "power", "weight", "acceleration", "year")
response <- "acceleration"
colnames <- c("power", "weight", "constant")
values <- c(0.5, 1.0, 100)
types <- c("lessthanequal", "lessthanequal", "lessthanequal")
numbers <- c(0, 0, 0)
con <- data.frame(names=colnames, values=values, types=types, constraint_numbers=numbers)
cars_model <- h2o.glm(y=response, solver="irlsm",
                                 x=predictors, 
                                 training_frame = cars,
                                 linear_constraints=as.h2o(con),
                                 lambda=0.0,
                                 family="gaussian")
print(h2o.all_constraints_passed(cars_model))
}
}
