% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.coef_names}
\alias{h2o.coef_names}
\title{Return the GLM coefficient names without building the actual GLM model by setting max_iterations=0.}
\usage{
h2o.coef_names(object)
}
\arguments{
\item{object}{an \linkS4class{H2OModel} object.}
}
\description{
Return the GLM coefficient names without building the actual GLM model by setting max_iterations=0.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/junit/cars_20mpg.csv"
cars <- h2o.importFile(f)
predictors <- c("displacement", "power", "weight", "acceleration", "year")
response <- "cylinders"
cars_glm <- h2o.glm(balance_classes = TRUE, 
                    seed = 1234, 
                    x = predictors, 
                    y = response, 
                    training_frame = cars,
                    max_iterations=0)
h2o.coef_names(cars_glm)
}
}
