% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hglm.R
\name{h2o.hglm}
\alias{h2o.hglm}
\title{Fits a HGLM model with both the residual noise and random effect being modeled by Gaussian distribution.  The fixed
effect coefficients are specified in parameter x, the random effect coefficients are specified in parameter 
random_columns.  The column specified in group_column will contain the level 2 index value and must be an enum column.}
\usage{
h2o.hglm(
  x,
  y,
  training_frame,
  random_columns,
  group_column,
  model_id = NULL,
  validation_frame = NULL,
  ignore_const_cols = TRUE,
  offset_column = NULL,
  weights_column = NULL,
  max_runtime_secs = 0,
  custom_metric_func = NULL,
  score_each_iteration = FALSE,
  score_iteration_interval = 5,
  seed = -1,
  missing_values_handling = c("MeanImputation", "Skip", "PlugValues"),
  plug_values = NULL,
  family = c("gaussian"),
  rand_family = c("gaussian"),
  max_iterations = -1,
  initial_fixed_effects = NULL,
  initial_random_effects = NULL,
  initial_t_matrix = NULL,
  tau_u_var_init = 0,
  tau_e_var_init = 0,
  method = c("EM"),
  em_epsilon = 0.001,
  random_intercept = TRUE,
  gen_syn_data = FALSE
)
}
\arguments{
\item{x}{(Optional) A vector containing the names or indices of the predictor variables to use in building the model.
If x is missing, then all columns except y are used.}

\item{y}{The name or column index of the response variable in the data. 
The response must be either a numeric or a categorical/factor variable. 
If the response is numeric, then a regression model will be trained, otherwise it will train a classification model.}

\item{training_frame}{Id of the training data frame.}

\item{random_columns}{Random columns indices for HGLM.}

\item{group_column}{Group column is the column that is categorical and used to generate the groups in HGLM}

\item{model_id}{Destination id for this model; auto-generated if not specified.}

\item{validation_frame}{Id of the validation data frame.}

\item{ignore_const_cols}{\code{Logical}. Ignore constant columns. Defaults to TRUE.}

\item{offset_column}{Offset column. This will be added to the combination of columns before applying the link function.}

\item{weights_column}{Column with observation weights. Giving some observation a weight of zero is equivalent to excluding it from
the dataset; giving an observation a relative weight of 2 is equivalent to repeating that row twice. Negative
weights are not allowed. Note: Weights are per-row observation weights and do not increase the size of the
data frame. This is typically the number of times a row is repeated, but non-integer values are supported as
well. During training, rows with higher weights matter more, due to the larger loss function pre-factor. If
you set weight = 0 for a row, the returned prediction frame at that row is zero and this is incorrect. To get
an accurate prediction, remove all rows with weight == 0.}

\item{max_runtime_secs}{Maximum allowed runtime in seconds for model training. Use 0 to disable. Defaults to 0.}

\item{custom_metric_func}{Reference to custom evaluation function, format: `language:keyName=funcName`}

\item{score_each_iteration}{\code{Logical}. Whether to score during each iteration of model training. Defaults to FALSE.}

\item{score_iteration_interval}{Perform scoring for every score_iteration_interval iterations. Defaults to 5.}

\item{seed}{Seed for random numbers (affects certain parts of the algo that are stochastic and those might or might not be enabled by default).
Defaults to -1 (time-based random number).}

\item{missing_values_handling}{Handling of missing values. Either MeanImputation, Skip or PlugValues. Must be one of: "MeanImputation",
"Skip", "PlugValues". Defaults to MeanImputation.}

\item{plug_values}{Plug Values (a single row frame containing values that will be used to impute missing values of the
training/validation frame, use with conjunction missing_values_handling = PlugValues).}

\item{family}{Family. Only gaussian is supported now. Must be one of: "gaussian". Defaults to gaussian.}

\item{rand_family}{Set distribution of random effects.  Only Gaussian is implemented now. Must be one of: "gaussian".}

\item{max_iterations}{Maximum number of iterations.  Value should >=1.  A value of 0 is only set when only the model coefficient
names and model coefficient dimensions are needed. Defaults to -1.}

\item{initial_fixed_effects}{An array that contains initial values of the fixed effects coefficient.}

\item{initial_random_effects}{A H2OFrame id that contains initial values of the random effects coefficient.  The row names shouldbe the
random coefficient names.  If you are not sure what the random coefficient names are, build HGLM model with
max_iterations = 0 and checkout the model output field random_coefficient_names.  The number of rows of this
frame should be the number of level 2 units.  Again, to figure this out, build HGLM model with
max_iterations=0 and check out the model output field group_column_names.  The number of rows should equal the
length of thegroup_column_names.}

\item{initial_t_matrix}{A H2OFrame id that contains initial values of the T matrix.  It should be a positive symmetric matrix.}

\item{tau_u_var_init}{Initial variance of random coefficient effects.  If set, should provide a value > 0.0.  If not set, will be
randomly set in the model building process. Defaults to 0.}

\item{tau_e_var_init}{Initial variance of random noise.  If set, should provide a value > 0.0.  If not set, will be randomly set in
the model building process. Defaults to 0.}

\item{method}{We only implemented EM as a method to obtain the fixed, random coefficients and the various variances. Must be
one of: "EM". Defaults to EM.}

\item{em_epsilon}{Converge if beta/ubeta/tmat/tauEVar changes less (using L-infinity norm) than em esilon. ONLY applies to EM
method. Defaults to 0.001.}

\item{random_intercept}{\code{Logical}. If true, will allow random component to the GLM coefficients. Defaults to TRUE.}

\item{gen_syn_data}{\code{Logical}. If true, add gaussian noise with variance specified in parms._tau_e_var_init. Defaults to
FALSE.}
}
\description{
Fits a HGLM model with both the residual noise and random effect being modeled by Gaussian distribution.  The fixed
effect coefficients are specified in parameter x, the random effect coefficients are specified in parameter 
random_columns.  The column specified in group_column will contain the level 2 index value and must be an enum column.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
# build a HGLM model with prostate dataset
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(path = prostate_path)
prostate$RACE <- as.factor(prostate$RACE)
model <- h2o.hglm(y="VOL", x=c("AGE","RACE","DPROS"), random_columns = ["AGE"], 
                  group_column = "RACE", training_frame=prostate)

}
}
