% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.result}
\alias{h2o.result}
\title{Retrieve the results to view the best predictor subsets.}
\usage{
h2o.result(model)
}
\arguments{
\item{model}{H2OModelSelection  object}
}
\value{
Returns an H2OFrame object
}
\description{
Retrieve the results to view the best predictor subsets.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

# Import the prostate dataset:
prostate <- h2o.importFile(
   "http://s3.amazonaws.com/h2o-public-test-data/smalldata/logreg/prostate.csv"
)

# Set the predictors & response:
predictors <- c("AGE", "RACE", "CAPSULE", "DCAPS", "PSA", "VOL", "DPROS")
response <- "GLEASON"

# Build & train the model:
allsubsetsModel <- h2o.modelSelection(x = predictors,
                                      y = response,
                                      training_frame = prostate,
                                      seed = 12345,
                                      max_predictor_number = 7,
                                      mode = "allsubsets")

# Retrieve the results (H2OFrame containing best model_ids, best_r2_value, & predictor subsets):
results <- h2o.result(allsubsetsModel)
print(results)

# Retrieve the list of coefficients:
coeff <- h2o.coef(allsubsetsModel)
print(coeff)

# Retrieve the list of coefficients for a subset size of 3:
coeff3 <- h2o.coef(allsubsetsModel, 3)
print(coeff3)

# Retrieve the list of standardized coefficients:
coeff_norm <- h2o.coef_norm(allsubsetsModel)
print(coeff_norm)

# Retrieve the list of standardized coefficients for a subset size of 3:
coeff_norm3 <- h2o.coef_norm(allsubsetsModel)
print(coeff_norm3)

# Check the variables that were added during this process:
h2o.get_predictors_added_per_step(allsubsetsModel)

# To find out which variables get removed, build a new model with ``mode = "backward``
# using the above training information:
bwModel <- h2o.modelSelection(x = predictors,
                              y = response,
                              training_frame = prostate,
                              seed = 12345,
                              max_predictor_number = 7,
                              mode = "backward")
h2o.get_predictors_removed_per_step(bwModel)

# To build the fastest model with ModelSelection, use ``mode = "maxrsweep"``:
sweepModel <- h2o.modelSelection(x = predictors,
                                 y = response,
                                 training_frame = prostate,
                                 mode = "maxrsweep",
                                 build_glm_model = FALSE,
                                 max_predictor_number = 3,
                                 seed = 12345)

# Retrieve the results to view the best predictor subsets:
h2o.result(sweepModel)
}

}
