% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.match}
\alias{h2o.match}
\alias{match.H2OFrame}
\alias{\%in\%}
\title{Value Matching in H2O}
\usage{
h2o.match(x, table, nomatch = NA_integer_, start_index = 1)

match.H2OFrame(x, table, nomatch = NA_integer_, start_index = 1)

x \%in\% table
}
\arguments{
\item{x}{a vector from an H2OFrame object with
values to be matched.}

\item{table}{an R object to match \code{x} against. Duplicates are ignored. The index of the first occurrence 
will be used.}

\item{nomatch}{the value to be returned in the case when no match is found. Numeric value or NaN, default is NaN.}

\item{start_index}{index from which this starts the indexing of the table list, numeric value >=0, default is 1.}
}
\value{
Returns a new H2OFrame containing a vector where the index of value from the table is returned 
       if the value matches; returns \code{nomatch} value otherwise.
}
\description{
\code{match} and \code{\%in\%} return values similar to the base R generic
functions.
}
\examples{
\dontrun{
h2o.init()
data <- as.h2o(iris)
match_col <- h2o.match(data$Species, c("setosa", "versicolor", "setosa"))
iris_match <- h2o.cbind(data, match_col)
sample <- h2o.splitFrame(iris_match, ratios=0.05, seed=1)[[1]]
sample
#   Sepal.Length Sepal.Width Petal.Length Petal.Width    Species  C1
#1          5.2         3.5          1.5         0.2     setosa   1
#2          5.0         3.5          1.3         0.3     setosa   1
#3          7.0         3.2          4.7         1.4 versicolor   2
#4          4.9         2.4          3.3         1.0 versicolor   2
#5          5.5         2.4          3.8         1.1 versicolor   2
#6          5.8         2.7          5.1         1.9  virginica NaN
}
}
\seealso{
\code{\link[base]{match}} for base R implementation.
}
