# This file is auto-generated by h2o-3/h2o-bindings/bin/gen_R.py
# Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details) 
#'
# -------------------------- H2O Stacked Ensemble -------------------------- #
#'
#' Builds a Stacked Ensemble
#' 
#' Build a stacked ensemble (aka. Super Learner) using the H2O base
#' learning algorithms specified by the user.
#'
#' @param x (Optional). A vector containing the names or indices of the predictor variables to use in building the model.
#'        If x is missing, then all columns except y are used.  Training frame is used only to compute ensemble training metrics.
#' @param y The name or column index of the response variable in the data. 
#'        The response must be either a numeric or a categorical/factor variable. 
#'        If the response is numeric, then a regression model will be trained, otherwise it will train a classification model.
#' @param training_frame Id of the training data frame.
#' @param model_id Destination id for this model; auto-generated if not specified.
#' @param validation_frame Id of the validation data frame.
#' @param blending_frame Frame used to compute the predictions that serve as the training frame for the metalearner (triggers blending
#'        mode if provided)
#' @param base_models List of models (or model ids) to ensemble/stack together. If not using blending frame, then models must have
#'        been cross-validated using nfolds > 1, and folds must be identical across models.
#' @param metalearner_algorithm Type of algorithm to use as the metalearner. Options include 'AUTO' (GLM with non negative weights; if
#'        validation_frame is present, a lambda search is performed), 'glm' (GLM with default parameters), 'gbm' (GBM
#'        with default parameters), 'drf' (Random Forest with default parameters), or 'deeplearning' (Deep Learning with
#'        default parameters). Must be one of: "AUTO", "glm", "gbm", "drf", "deeplearning". Defaults to AUTO.
#' @param metalearner_nfolds Number of folds for K-fold cross-validation of the metalearner algorithm (0 to disable or >= 2). Defaults to
#'        0.
#' @param metalearner_fold_assignment Cross-validation fold assignment scheme for metalearner cross-validation.  Defaults to AUTO (which is
#'        currently set to Random). The 'Stratified' option will stratify the folds based on the response variable, for
#'        classification problems. Must be one of: "AUTO", "Random", "Modulo", "Stratified".
#' @param metalearner_fold_column Column with cross-validation fold index assignment per observation for cross-validation of the metalearner.
#' @param metalearner_params Parameters for metalearner algorithm
#' @param seed Seed for random numbers; passed through to the metalearner algorithm. Defaults to -1 (time-based random number).
#' @param keep_levelone_frame \code{Logical}. Keep level one frame used for metalearner training. Defaults to FALSE.
#' @param export_checkpoints_dir Automatically export generated models to this directory.
#' @examples
#' \dontrun{
#' # See example R code here:
#' # http://docs.h2o.ai/h2o/latest-stable/h2o-docs/data-science/stacked-ensembles.html
#' }
#' @export
h2o.stackedEnsemble <- function(x,
                                y,
                                training_frame,
                                model_id = NULL,
                                validation_frame = NULL,
                                blending_frame = NULL,
                                base_models = list(),
                                metalearner_algorithm = c("AUTO", "glm", "gbm", "drf", "deeplearning"),
                                metalearner_nfolds = 0,
                                metalearner_fold_assignment = c("AUTO", "Random", "Modulo", "Stratified"),
                                metalearner_fold_column = NULL,
                                metalearner_params = NULL,
                                seed = -1,
                                keep_levelone_frame = FALSE,
                                export_checkpoints_dir = NULL)
{
  # Validate required training_frame first and other frame args: should be a valid key or an H2OFrame object
  training_frame <- .validate.H2OFrame(training_frame, required=TRUE)
  validation_frame <- .validate.H2OFrame(validation_frame, required=FALSE)
  blending_frame <- .validate.H2OFrame(blending_frame, required=FALSE)

  # Validate other required args
  # If x is missing, then assume user wants to use all columns as features.
  if (missing(x)) {
     if (is.numeric(y)) {
         x <- setdiff(col(training_frame), y)
     } else {
         x <- setdiff(colnames(training_frame), y)
     }
  }

  # Validate other args
  # Get the base models from model IDs (if any) that will be used for constructing model summary
  if(!is.list(base_models) && is.vector(x)) {
     base_models <- as.list(base_models)
  }
  baselearners <- lapply(base_models, function(base_model) {
    if (is.character(base_model))
      base_model <- h2o.getModel(base_model)
    base_model
  })

  # Get base model IDs that will be passed to REST API later
  if (length(base_models) == 0) stop('base_models is empty')

  # If base_models contains models instead of ids, replace with model id
  for (i in 1:length(base_models)) {
    if (inherits(base_models[[i]], 'H2OModel')) {
      base_models[[i]] <- base_models[[i]]@model_id
    }
  }

  # Build parameter list to send to model builder
  parms <- list()
  parms$training_frame <- training_frame
  args <- .verify_dataxy(training_frame, x, y)
  parms$response_column <- args$y

  if (!missing(model_id))
    parms$model_id <- model_id
  if (!missing(validation_frame))
    parms$validation_frame <- validation_frame
  if (!missing(blending_frame))
    parms$blending_frame <- blending_frame
  if (!missing(base_models))
    parms$base_models <- base_models
  if (!missing(metalearner_algorithm))
    parms$metalearner_algorithm <- metalearner_algorithm
  if (!missing(metalearner_nfolds))
    parms$metalearner_nfolds <- metalearner_nfolds
  if (!missing(metalearner_fold_assignment))
    parms$metalearner_fold_assignment <- metalearner_fold_assignment
  if (!missing(metalearner_fold_column))
    parms$metalearner_fold_column <- metalearner_fold_column
  if (!missing(seed))
    parms$seed <- seed
  if (!missing(keep_levelone_frame))
    parms$keep_levelone_frame <- keep_levelone_frame
  if (!missing(export_checkpoints_dir))
    parms$export_checkpoints_dir <- export_checkpoints_dir

  if (!missing(metalearner_params))
      parms$metalearner_params <- as.character(toJSON(metalearner_params, pretty = TRUE))

  # Error check and build model
  model <- .h2o.modelJob('stackedensemble', parms, h2oRestApiVersion=99, verbose=FALSE)

  # Convert metalearner_params back to list if not NULL
  if (!missing(metalearner_params)) {
      model@parameters$metalearner_params <- list(fromJSON(model@parameters$metalearner_params))[[1]] #Need the `[[ ]]` to avoid a nested list
  }
  model@model$model_summary <- capture.output({

    print_ln <- function(...) cat(..., sep = "\n")

    print_ln(paste0("Number of Base Models: ", length(baselearners)))
    print_ln("\nBase Models (count by algorithm type):")
    print(table(unlist(lapply(baselearners, function(baselearner) baselearner@algorithm))))


    print_ln("\nMetalearner:\n")
    print_ln(paste0(
      "Metalearner algorithm: ",
      ifelse(length(metalearner_algorithm) > 1, "glm", metalearner_algorithm)))

    if (metalearner_nfolds != 0) {
      print_ln("Metalearner cross-validation fold assignment:")
      print_ln(paste0(
        "  Fold assignment scheme: ",
        ifelse(length(metalearner_fold_assignment) > 1, "Random", metalearner_fold_assignment)))
      print_ln(paste0("  Number of folds: ", metalearner_nfolds))
      print_ln(paste0(
        "  Fold column: ",
        ifelse(is.null(metalearner_fold_column), "NULL", metalearner_fold_column )))
    }

    if (!missing(metalearner_params))
      print_ln(paste0("Metalearner hyperparameters: ", parms$metalearner_params))

  })
  class(model@model$model_summary) <- "h2o.stackedEnsemble.summary"
  return(model)
}
