# This file is auto-generated by h2o-3/h2o-bindings/bin/gen_R.py
# Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details) 
#'
# -------------------------- Target Encoder -------------------------- #
#'
#' Transformation of a categorical variable with a mean value of the target variable
#'
#' @param x (Optional) A vector containing the names or indices of the predictor variables to use in building the model.
#'        If x is missing, then all columns except y are used.
#' @param y The name or column index of the response variable in the data. 
#'        The response must be either a numeric or a categorical/factor variable. 
#'        If the response is numeric, then a regression model will be trained, otherwise it will train a classification model.
#' @param training_frame Id of the training data frame.
#' @param blending \code{Logical}. Blending enabled/disabled Defaults to FALSE.
#' @param k Inflection point. Used for blending (if enabled). Blending is to be enabled separately using the 'blending'
#'        parameter. Defaults to 20.
#' @param f Smooothing. Used for blending (if enabled). Blending is to be enabled separately using the 'blending'
#'        parameter. Defaults to 10.
#' @param data_leakage_handling Data leakage handling strategy. Default to None. Must be one of: "None", "KFold", "LeaveOneOut". Defaults to
#'        None.
#' @param model_id Destination id for this model; auto-generated if not specified.
#' @param fold_column Column with cross-validation fold index assignment per observation.
#' @examples
#' \dontrun{
#' # library(h2o)
#' # h2o.init()
#' #
#' # Create a target encoder
#' # target_encoder <- h2o.targetencoder(training_frame = data, encoded_columns= encoded_columns,
#' # target_column = "survived", fold_column = "pclass", data_leakage_handling = "KFold")
#' #
#' # Apply the Target Encoder transformation
#' # encoded_data <- h2o.transform(target_encoder, data)
#' }
#' @export
h2o.targetencoder <- function(x,
                              y,
                              training_frame,
                              blending = FALSE,
                              k = 20,
                              f = 10,
                              data_leakage_handling = c("None", "KFold", "LeaveOneOut"),
                              model_id = NULL,
                              fold_column = NULL)
{
  # Validate required training_frame first and other frame args: should be a valid key or an H2OFrame object
  training_frame <- .validate.H2OFrame(training_frame, required=TRUE)

  # Validate other required args
  # If x is missing, then assume user wants to use all columns as features.
  if (missing(x)) {
     if (is.numeric(y)) {
         x <- setdiff(col(training_frame), y)
     } else {
         x <- setdiff(colnames(training_frame), y)
     }
  }

  # Build parameter list to send to model builder
  parms <- list()
  args <- .verify_dataxy(training_frame, x, y)
  if( !missing(fold_column) && !is.null(fold_column)) args$x_ignore <- args$x_ignore[!( fold_column == args$x_ignore )]
  parms$ignored_columns <- args$x_ignore
  parms$response_column <- args$y
  parms$training_frame <- training_frame

  if (!missing(blending))
    parms$blending <- blending
  if (!missing(k))
    parms$k <- k
  if (!missing(f))
    parms$f <- f
  if (!missing(data_leakage_handling))
    parms$data_leakage_handling <- data_leakage_handling
  if (!missing(model_id))
    parms$model_id <- model_id
  if (!missing(fold_column))
    parms$fold_column <- fold_column

  # Error check and build model
  model <- .h2o.modelJob('targetencoder', parms, h2oRestApiVersion=3, verbose=FALSE)
  return(model)
}
