% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\docType{class}
\name{H2OTree-class}
\alias{H2OTree-class}
\alias{H2OTree}
\alias{show,H2OTree-method}
\title{The H2OTree class.}
\usage{
\S4method{show}{H2OTree}(object)
}
\arguments{
\item{object}{an \code{H2OTree} object.}
}
\description{
This class represents a model of a Tree built by one of H2O's algorithms (GBM, Random Forest).
}
\section{Slots}{

\describe{
\item{\code{root_node}}{A \code{H2ONode} representing the beginning of the tree behind the model. Allows further tree traversal.}

\item{\code{left_children}}{An \code{integer} vector with left child nodes of tree's nodes}

\item{\code{right_children}}{An \code{integer} vector with right child nodes of tree's nodes}

\item{\code{node_ids}}{An \code{integer} representing identification number of a node. Node IDs are generated by H2O.}

\item{\code{descriptions}}{A \code{character} vector with descriptions for each node to be found in the tree. Contains split threshold if the split is based on numerical column.
For cactegorical splits, it contains list of categorical levels for transition from the parent node.}

\item{\code{model_id}}{A \code{character} with the name of the model this tree is related to.}

\item{\code{tree_number}}{An \code{integer} representing the order in which the tree has been built in the model.}

\item{\code{tree_class}}{A \code{character} representing name of tree's class. Number of tree classes equals to the number of levels in categorical response column.
As there is exactly one class per categorical level, name of tree's class equals to the corresponding categorical level of response column.
In case of regression and binomial, the name of the categorical level is ignored can be omitted, as there is exactly one tree built in both cases.}

\item{\code{thresholds}}{A \code{numeric} split thresholds. Split thresholds are not only related to numerical splits, but might be present in case of categorical split as well.}

\item{\code{features}}{A \code{character} with names of the feature/column used for the split.}

\item{\code{levels}}{A \code{character} representing categorical levels on split from parent's node belonging into this node. NULL for root node or non-categorical splits.}

\item{\code{nas}}{A \code{character} representing if NA values go to the left node or right node. May be NA if node is a leaf.}

\item{\code{predictions}}{A \code{numeric} representing predictions for each node in the graph.}
}}

