% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{h2o.downloadCSV}
\alias{h2o.downloadCSV}
\title{Download H2O Data to Disk}
\usage{
h2o.downloadCSV(data, filename)
}
\arguments{
\item{data}{an H2OFrame object to be downloaded.}

\item{filename}{A string indicating the name that the CSV file should be
should be saved to.}
}
\description{
Download an H2O data set to a CSV file on the local disk
}
\section{Warning}{
 Files located on the H2O server may be very large! Make
       sure you have enough hard drive space to accomodate the entire file.
}

\examples{
\dontrun{
library(h2o)
h2o.init()
iris_hf <- as.h2o(iris)

file_path <- paste(getwd(), "my_iris_file.csv", sep = .Platform$file.sep)
h2o.downloadCSV(iris_hf, file_path)
file.info(file_path)
file.remove(file_path)
}
}
