% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psvm.R
\name{h2o.psvm}
\alias{h2o.psvm}
\title{Trains a Support Vector Machine model on an H2O dataset}
\usage{
h2o.psvm(x, y, training_frame, model_id = NULL,
  validation_frame = NULL, ignore_const_cols = TRUE, hyper_param = 1,
  kernel_type = c("gaussian"), gamma = -1, rank_ratio = -1,
  positive_weight = 1, negative_weight = 1,
  disable_training_metrics = TRUE, sv_threshold = 1e-04,
  fact_threshold = 1e-05, feasible_threshold = 0.001,
  surrogate_gap_threshold = 0.001, mu_factor = 10,
  max_iterations = 200, seed = -1)
}
\arguments{
\item{x}{(Optional) A vector containing the names or indices of the predictor variables to use in building the model.
If x is missing, then all columns except y are used.}

\item{y}{The name or column index of the response variable in the data. The response must be either a binary
categorical/factor variable or a numeric variable with values -1/1 (for compatibility with SVMlight format).}

\item{training_frame}{Id of the training data frame.}

\item{model_id}{Destination id for this model; auto-generated if not specified.}

\item{validation_frame}{Id of the validation data frame.}

\item{ignore_const_cols}{\code{Logical}. Ignore constant columns. Defaults to TRUE.}

\item{hyper_param}{Penalty parameter C of the error term Defaults to 1.}

\item{kernel_type}{Type of used kernel Must be one of: "gaussian". Defaults to gaussian.}

\item{gamma}{Coefficient of the kernel (currently RBF gamma for gaussian kernel, -1 means 1/#features) Defaults to -1.}

\item{rank_ratio}{Desired rank of the ICF matrix expressed as an ration of number of input rows (-1 means use sqrt(#rows)).
Defaults to -1.}

\item{positive_weight}{Weight of positive (+1) class of observations Defaults to 1.}

\item{negative_weight}{Weight of positive (-1) class of observations Defaults to 1.}

\item{disable_training_metrics}{\code{Logical}. Disable calculating training metrics (expensive on large datasets) Defaults to TRUE.}

\item{sv_threshold}{Threshold for accepting a candidate observation into the set of support vectors Defaults to 0.0001.}

\item{fact_threshold}{Convergence threshold of the Incomplete Cholesky Factorization (ICF) Defaults to 1e-05.}

\item{feasible_threshold}{Convergence threshold for primal-dual residuals in the IPM iteration Defaults to 0.001.}

\item{surrogate_gap_threshold}{Feasibility criterion of the surrogate duality gap (eta) Defaults to 0.001.}

\item{mu_factor}{Increasing factor mu Defaults to 10.}

\item{max_iterations}{Maximum number of iteration of the algorithm Defaults to 200.}

\item{seed}{Seed for random numbers (affects certain parts of the algo that are stochastic and those might or might not be enabled by default).
Defaults to -1 (time-based random number).}
}
\description{
Alpha version. Supports only binomial classification problems.
}
