% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/communication.R
\name{.h2o.doRawPOST}
\alias{.h2o.doRawPOST}
\title{Perform a low-level HTTP POST operation on an H2O instance}
\usage{
.h2o.doRawPOST(conn = h2o.getConnection(), h2oRestApiVersion, urlSuffix,
  parms, fileUploadInfo, ...)
}
\arguments{
\item{conn}{H2OConnection}

\item{h2oRestApiVersion}{(Optional) A version number to prefix to the urlSuffix.  If no version is provided, the version prefix is skipped.}

\item{urlSuffix}{The partial URL suffix to add to the calculated base URL for the instance}

\item{parms}{(Optional) Parameters to include in the request}

\item{fileUploadInfo}{(Optional) Information to POST (NOTE: changes Content-type from XXX-www-url-encoded to multi-part).  Use fileUpload(normalizePath("/path/to/file")).}

\item{...}{(Optional) Additional parameters.}
}
\value{
A list object as described above
}
\description{
Does not do any I/O level error checking.  Caller must do its own validations.
Does not modify the response payload in any way.
Log the request and response if h2o.startLogging() has been called.
}
\details{
The return value is a list as follows:
    $url                -- Final calculated URL.
    $postBody           -- The body of the POST request from client to server.
    $curlError          -- TRUE if a socket-level error occurred.  FALSE otherwise.
    $curlErrorMessage   -- If curlError is TRUE a message about the error.
    $httpStatusCode     -- The HTTP status code.  Usually 200 if the request succeeded.
    $httpStatusMessage  -- A string describing the httpStatusCode.
    $payload            -- The raw response payload as a character vector.
}
