% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{h2o.shap_summary_plot}
\alias{h2o.shap_summary_plot}
\title{SHAP Summary Plot}
\usage{
h2o.shap_summary_plot(
  model,
  newdata,
  columns = NULL,
  top_n_features = 20,
  sample_size = 1000
)
}
\arguments{
\item{model}{An H2O tree-based model. This includes Random Forest, GBM and XGboost
only. Must be a binary classification or regression model.}

\item{newdata}{An H2O Frame, used to determine feature contributions.}

\item{columns}{List of columns or list of indices of columns to show.
If specified, then the \code{top_n_features} parameter will be ignored.}

\item{top_n_features}{Integer specifying the maximum number of columns to show (ranked by variable importance).}

\item{sample_size}{Integer specifying the maximum number of observations to be plotted.}
}
\value{
A ggplot2 object
}
\description{
SHAP summary plot shows the contribution of the features for each instance (row of data).
The sum of the feature contributions and the bias term is equal to the raw prediction
of the model, i.e., prediction before applying inverse link function.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

# Import the wine dataset into H2O:
f <- "https://h2o-public-test-data.s3.amazonaws.com/smalldata/wine/winequality-redwhite-no-BOM.csv"
df <-  h2o.importFile(f)

# Set the response
response <- "quality"

# Split the dataset into a train and test set:
splits <- h2o.splitFrame(df, ratios = 0.8, seed = 1)
train <- splits[[1]]
test <- splits[[2]]

# Build and train the model:
gbm <- h2o.gbm(y = response,
               training_frame = train)

# Create the SHAP summary plot
shap_summary_plot <- h2o.shap_summary_plot(gbm, test)
print(shap_summary_plot)
}
}
